# Car Rental Flask API

This is a small Flask application exposing CRUD endpoints for Cars and Reservations using SQLAlchemy and MySQL.

Environment variables (or set a DATABASE_URL):

- MYSQL_USER (default: root)
- MYSQL_PASSWORD (default: empty)
- MYSQL_HOST (default: localhost)
- MYSQL_PORT (default: 3306)
- MYSQL_DB (default: car_rental)
- DATABASE_URL (optional; overrides the pieces above)

Install dependencies:

```bash
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

Run tests:

```bash
/your/path/to/.venv/bin/python -m pytest -q
# or simply
pytest -q
```

Run the app:

```bash
export MYSQL_USER=root
export MYSQL_PASSWORD=yourpass
export MYSQL_DB=car_rental
python app.py
```

Database migrations (Flask-Migrate / Alembic)

After installing requirements, initialize and run migrations with the Flask CLI. Example:

```bash
export FLASK_APP=app:create_app
flask db init        # only once
flask db migrate -m "initial"
flask db upgrade
```

This will create an `migrations/` folder and apply the schema to the configured database.

API endpoints summary:

- GET /cars
- GET /cars/<id>
- POST /cars
- PUT /cars/<id>
- DELETE /cars/<id>

- GET /reservations
- GET /reservations/<id>
- POST /reservations
- PUT /reservations/<id>
- DELETE /reservations/<id>

Notes:
- Dates must be ISO formatted strings (e.g. 2025-11-17T12:00:00)
- Car `ports` must be either 3 or 5.
- Car `type` must be one of 'suv', 'small', 'van'.
