-- Seed data for the car_rental database
-- Creates the database if missing and inserts some sample cars and reservations.
-- Run with: mysql -u "$MYSQL_USER" -p"$MYSQL_PASSWORD" -h "$MYSQL_HOST" -P "$MYSQL_PORT" "$MYSQL_DB" < seeds/seed_data.sql

CREATE DATABASE IF NOT EXISTS `car_rental`;
USE `car_rental`;

-- Cars
INSERT INTO cars (id, name, seats, ports, type, brand, license_plate) VALUES
  (1, 'Toyota RAV4', 5, 3, 'suv', 'Toyota', 'ABC-1234'),
  (2, 'Honda Civic', 5, 3, 'small', 'Honda', 'CIV-2025'),
  (3, 'Ford Transit', 12, 5, 'van', 'Ford', 'VAN-9001')
ON DUPLICATE KEY UPDATE name=VALUES(name);

-- Reservations
INSERT INTO reservations (id, pickup_date, return_date, car_id, customer_fullname, drive_license) VALUES
  (1, '2025-11-18 10:00:00', '2025-11-20 12:00:00', 1, 'Alice Example', 'DL1234567'),
  (2, '2025-12-01 09:00:00', '2025-12-05 17:00:00', 3, 'Bob Driver', 'DL7654321')
ON DUPLICATE KEY UPDATE customer_fullname=VALUES(customer_fullname);
